﻿Public Class Bullet
    Inherits ModelWorldObject

    Private _StartPosition As Vector3
    Private _SourceObject As WorldObject

    Public Property QuatRotation As Quaternion

    Public ReadOnly Property StartPosition As Vector3
        Get
            Return Me._StartPosition
        End Get
    End Property

    Public ReadOnly Property SourceObject As WorldObject
        Get
            Return Me._SourceObject
        End Get
    End Property

    Public Property Power As Single

    Sub New(game As Game, world As VirtualWorld, position As Vector3, rotation As Vector3, modelName As String, sourceObject As WorldObject, power As Integer)
        MyBase.New(game, world, position, rotation, New Vector3(0.2), modelName)
        Me._StartPosition = position
        Me.Power = power
        Me._SourceObject = sourceObject
    End Sub

    Sub New(game As Game, world As VirtualWorld, position As Vector3, rotation As Vector3, model As Model, sourceObject As WorldObject, power As Integer)
        MyBase.New(game, world, position, rotation, New Vector3(0.2), model)
        Me._StartPosition = position
        Me.Power = power
        Me._SourceObject = sourceObject
    End Sub

    Public Overrides Sub Update(gameTime As Microsoft.Xna.Framework.GameTime)
        Dim addVector As Vector3 = Vector3.Transform(New Vector3(0, 0, 1), Me.QuatRotation)
        Me.Position += addVector * Me.World.BulletSpeed
        For Each o As WorldObject In Me.World.GetShootableObjects
            If Not o Is Nothing AndAlso Not o Is Me AndAlso Not o Is Me.SourceObject Then
                If Me.BoundingSphere.Intersects(o.BoundingBox) Then
                    o.OnShot(Me)
                    Me.World.CreateExplosion(Me.Position)
                    Me.Dispose()
                End If
            End If
        Next
        If Vector3.Distance(Me.World.CameraCarrier.Position, Me.Position) > Me.World.BulletRange Then
            Me.Dispose()
        End If
        MyBase.Update(gameTime)
    End Sub

    Public Shared Sub FireBullet(game As Game, world As VirtualWorld, bulletPosition As Vector3, forwardDirection As Single, sourceObject As WorldObject, power As Integer)
        Dim newBullet As New Bullet(game, world, bulletPosition, Vector3.Zero, world.BulletModel, sourceObject, power)
        newBullet.QuatRotation = Quaternion.CreateFromRotationMatrix(Matrix.CreateRotationY(forwardDirection))
        world.BulletList.Add(newBullet)
        world.GunShotSound.Play(0.1F, 0.0F, 0.0F)
    End Sub


    Public Overrides Sub Draw(gameTime As Microsoft.Xna.Framework.GameTime)
        Dim transforms(Me.Model.Bones.Count) As Matrix
        Me.Model.CopyAbsoluteBoneTransformsTo(transforms)
        Dim translateMatrix As Matrix = Matrix.CreateTranslation(Me.Position)
        Dim scaleMatrix As Matrix = Matrix.CreateScale(Me.Scale)
        Dim worldMatrix As Matrix = scaleMatrix * translateMatrix
        Me.BeginDraw(Me.World.ViewMatrix, Me.World.ProjectionMatrix, Me.GraphicsDevice, Me.World.Effect)
        For Each mesh As ModelMesh In Model.Meshes
            For Each e As BasicEffect In mesh.Effects
                e.World = worldMatrix * transforms(mesh.ParentBone.Index)
                e.View = Me.World.ViewMatrix
                e.Projection = Me.World.ProjectionMatrix
                e.EnableDefaultLighting()
                e.EmissiveColor = New Vector3(1, 1, 1)
                e.PreferPerPixelLighting = True
            Next
            mesh.Draw()
        Next
        Me.EndDraw(Me.World.ViewMatrix, Me.World.ProjectionMatrix, Me.GraphicsDevice, Me.World.Effect)
    End Sub

End Class
